////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  OBFontSpec.h
//    A Font specification.
//
//  Copyright (C) 2011 MYOB US, Inc., all rights reserved.
//
//  Change History (most recent first):
//
//	02/11/11  K.L.S.  Created file.
//
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#pragma once

#include "CrossPlatform/CrossPlatform.h"

class EXTERNAL_API OBFontSpec
{
public:
	static OBFontSpec FontSpecWithNameSizeAndStyle(const CPString& FontName, float Size, int Style);

	OBFontSpec(void);
	OBFontSpec(const OBFontSpec& Font);
	virtual ~OBFontSpec(void);

	const OBFontSpec& operator=(const OBFontSpec& Font);

	void SetName(const CPString& Name);
	CPString Name(void) const;
	CPString& Name(void);

	void SetStyle(int Style);
	int Style(void) const;
	int& Style(void);

	void SetSize(float Size);
	float Size(void) const;
	float& Size(void);

protected:
	OBFontSpec(const CPString& Font, float Size, int Style);

private:
	float m_Size;
	int m_Style;
	CPString m_Name;
};
